# VS Canvas 3.0

File-based WordPress script enqueuing with dependency management.

## What Changed in 3.0

- WordPress native `wp_enqueue_script()` system (no more raw HTML injection)
- Scripts load from files in `assets/scripts/custom/`
- Config-driven in `includes/vsc-config.php`
- Database stores only enabled/pages settings
- Automatic migration from 2.x

## Usage

1. Create `.js` or `.css` file in `assets/scripts/custom/`
2. Add entry to `includes/vsc-config.php`
3. Enable/configure via admin panel at **VS Canvas** menu

## Example

**File:** `assets/scripts/custom/hero-animations.js`
```javascript
gsap.from('.hero', {y: 50, opacity: 0});
```

**Config:** `includes/vsc-config.php`
```php
'hero-animations' => array(
    'name' => 'Hero Animations',
    'file' => 'custom/hero-animations.js',
    'deps' => array('gsap'),
    'version' => '1.0.0',
    'type' => 'js',
    'default_enabled' => false,
    'default_pages' => array(),
),
```

Then toggle on/off and configure page targeting in admin UI!
