<?php
if (!defined('ABSPATH')) exit;

class VSC_Admin {
    public function __construct() {
        add_action('admin_menu', array($this, 'add_menu'));
        add_action('wp_ajax_vsc_toggle_dependency', array($this, 'ajax_toggle_dependency'));
        add_action('wp_ajax_vsc_toggle_script', array($this, 'ajax_toggle_script'));
    }

    public function add_menu() {
        add_menu_page('VS Canvas', 'VS Canvas', 'manage_options', 'vs-canvas', array($this, 'render_page'), 'dashicons-art', 25);
    }

    public function render_page() {
        $dependencies = VSC_Core::get_dependencies();
        $scripts = VSC_Core::get_scripts();
        ?>
        <div class="wrap">
            <h1>VS Canvas - File-Based Script Management</h1>
            <p>Scripts load from <code>assets/scripts/custom/</code>. Edit <code>includes/vsc-config.php</code> to register new scripts.</p>

            <h2>Dependencies</h2>
            <table class="widefat">
                <thead><tr><th>Name</th><th>URL</th><th>Enabled</th></tr></thead>
                <tbody>
                <?php foreach ($dependencies as $id => $dep): ?>
                    <tr>
                        <td><?php echo esc_html($id); ?></td>
                        <td><code><?php echo esc_html($dep['url']); ?></code></td>
                        <td><input type="checkbox" class="vsc-dep-toggle" data-id="<?php echo esc_attr($id); ?>" <?php checked($dep['enabled']); ?>></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <h2>Custom Scripts</h2>
            <table class="widefat">
                <thead><tr><th>Name</th><th>File</th><th>Type</th><th>Enabled</th></tr></thead>
                <tbody>
                <?php foreach ($scripts as $id => $script): ?>
                    <tr>
                        <td><?php echo esc_html($script['name']); ?></td>
                        <td><code><?php echo esc_html($script['file']); ?></code></td>
                        <td><?php echo esc_html($script['type']); ?></td>
                        <td><input type="checkbox" class="vsc-script-toggle" data-id="<?php echo esc_attr($id); ?>" <?php checked($script['enabled']); ?>></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <script>
        jQuery(document).ready(function($) {
            $('.vsc-dep-toggle').on('change', function() {
                $.post(ajaxurl, {
                    action: 'vsc_toggle_dependency',
                    id: $(this).data('id'),
                    enabled: this.checked ? 1 : 0,
                    nonce: '<?php echo wp_create_nonce('vsc_toggle_dependency'); ?>'
                });
            });
            $('.vsc-script-toggle').on('change', function() {
                $.post(ajaxurl, {
                    action: 'vsc_toggle_script',
                    id: $(this).data('id'),
                    enabled: this.checked ? 1 : 0,
                    nonce: '<?php echo wp_create_nonce('vsc_toggle_script'); ?>'
                });
            });
        });
        </script>
        <?php
    }

    public function ajax_toggle_dependency() {
        check_ajax_referer('vsc_toggle_dependency', 'nonce');
        if (!current_user_can('manage_options')) wp_send_json_error();
        VSC_Core::update_dependency_settings($_POST['id'], !empty($_POST['enabled']));
        wp_send_json_success();
    }

    public function ajax_toggle_script() {
        check_ajax_referer('vsc_toggle_script', 'nonce');
        if (!current_user_can('manage_options')) wp_send_json_error();
        $settings = get_option('vsc_script_settings', array());
        $pages = isset($settings[$_POST['id']]['pages']) ? $settings[$_POST['id']]['pages'] : array();
        VSC_Core::update_script_settings($_POST['id'], !empty($_POST['enabled']), $pages);
        wp_send_json_success();
    }
}
