<?php
if (!defined('ABSPATH')) exit;

class VSC_Core {
    private static function load_config() {
        $config_file = VSC_PLUGIN_DIR . 'includes/vsc-config.php';
        if (!file_exists($config_file)) {
            return array('scripts' => array(), 'dependencies' => array());
        }
        $config = include $config_file;
        if (!isset($config['scripts'])) $config['scripts'] = array();
        if (!isset($config['dependencies'])) $config['dependencies'] = array();
        return $config;
    }

    public static function get_dependencies() {
        $config = self::load_config();
        $settings = get_option('vsc_dependency_settings', array());
        $deps = array();
        foreach ($config['dependencies'] as $id => $dep) {
            $dep['id'] = $id;
            $dep['enabled'] = isset($settings[$id]['enabled']) ? $settings[$id]['enabled'] : $dep['default_enabled'];
            $deps[$id] = $dep;
        }
        return $deps;
    }

    public static function get_enabled_dependencies() {
        $deps = self::get_dependencies();
        return array_filter($deps, function($dep) { return !empty($dep['enabled']); });
    }

    public static function update_dependency_settings($id, $enabled) {
        $settings = get_option('vsc_dependency_settings', array());
        $settings[$id] = array('enabled' => (bool) $enabled);
        return update_option('vsc_dependency_settings', $settings);
    }

    public static function get_scripts() {
        $config = self::load_config();
        $settings = get_option('vsc_script_settings', array());
        $scripts = array();
        foreach ($config['scripts'] as $id => $script) {
            $script['id'] = $id;
            $script['enabled'] = isset($settings[$id]['enabled']) ? $settings[$id]['enabled'] : $script['default_enabled'];
            $script['pages'] = isset($settings[$id]['pages']) ? $settings[$id]['pages'] : $script['default_pages'];
            $scripts[$id] = $script;
        }
        return $scripts;
    }

    public static function get_enabled_scripts() {
        $scripts = self::get_scripts();
        return array_filter($scripts, function($script) { return !empty($script['enabled']); });
    }

    public static function update_script_settings($id, $enabled, $pages) {
        $settings = get_option('vsc_script_settings', array());
        $settings[$id] = array(
            'enabled' => (bool) $enabled,
            'pages' => array_map('intval', (array) $pages),
        );
        return update_option('vsc_script_settings', $settings);
    }
}
