<?php
if (!defined('ABSPATH')) exit;

class VSC_Frontend {
    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'register_dependencies'), 1);
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'), 10);
    }

    public function register_dependencies() {
        $deps = VSC_Core::get_dependencies();
        foreach ($deps as $id => $dep) {
            $handle = 'vsc-dep-' . $id;
            if ($dep['type'] === 'css') {
                wp_register_style($handle, $dep['url'], $this->prefix_deps($dep['deps']), $dep['version']);
            } else {
                wp_register_script($handle, $dep['url'], $this->prefix_deps($dep['deps']), $dep['version'], true);
            }
        }
    }

    public function enqueue_scripts() {
        $scripts = VSC_Core::get_enabled_scripts();
        $dependencies = VSC_Core::get_enabled_dependencies();

        foreach ($dependencies as $id => $dep) {
            $handle = 'vsc-dep-' . $id;
            if ($dep['type'] === 'css') {
                wp_enqueue_style($handle);
            } else {
                wp_enqueue_script($handle);
            }
        }

        foreach ($scripts as $id => $script) {
            if (!$this->should_load_script($script)) continue;

            // Use minified version if available (production mode)
            $file_url = vsc_get_asset_url(VSC_PLUGIN_URL, VSC_PLUGIN_DIR, 'assets/scripts/' . $script['file']);
            $handle = 'vsc-' . $id;

            if ($script['type'] === 'css') {
                wp_enqueue_style($handle, $file_url, $this->prefix_deps($script['deps']), $script['version']);
            } else {
                wp_enqueue_script($handle, $file_url, $this->prefix_deps($script['deps']), $script['version'], true);
            }
        }
    }

    private function should_load_script($script) {
        if (empty($script['pages'])) return true;
        $current_page_id = get_the_ID();
        if (!$current_page_id) return false;
        return in_array($current_page_id, $script['pages']);
    }

    private function prefix_deps($deps) {
        return array_map(function($dep) { return 'vsc-dep-' . $dep; }, $deps);
    }
}
