<?php
/**
 * Cache Management Page
 *
 * Cache statistics and management controls
 *
 * @package VS_Site_Vector
 * @since 2.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$cache_stats = get_option('vssv_cache_stats', array(
    'hits' => 0,
    'misses' => 0,
    'writes' => 0,
    'deletes' => 0,
));
$cache_enabled = get_option('vssv_cache_enabled', true);

// Calculate hit rate
$total_requests = $cache_stats['hits'] + $cache_stats['misses'];
$hit_rate = $total_requests > 0 ? round(($cache_stats['hits'] / $total_requests) * 100) : 0;
?>
<div class="vs-page">
    <div class="vs-page-header">
        <h1>Cache Management</h1>
        <div class="vs-page-actions">
            <button
                class="vs-btn vs-btn-danger"
                onclick="vssv_clearCache()"
            >
                <i data-lucide="trash-2" style="width:16px;height:16px;margin-right:6px;"></i>
                Clear All Caches
            </button>
        </div>
    </div>

    <!-- Cache Stats -->
    <div class="vs-stats-grid">
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo number_format($cache_stats['hits']); ?></div>
            <div class="vs-stat-card-label">Cache Hits</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo number_format($cache_stats['misses']); ?></div>
            <div class="vs-stat-card-label">Cache Misses</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo $hit_rate; ?>%</div>
            <div class="vs-stat-card-label">Hit Rate</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo number_format($cache_stats['writes']); ?></div>
            <div class="vs-stat-card-label">Cache Writes</div>
        </div>
    </div>

    <!-- Cache Settings -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="settings" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Cache Settings
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked($cache_enabled); ?> data-option="vssv_cache_enabled">
                    Enable Page Caching
                </label>
                <p class="vs-setting-desc">Cache rendered pages for faster subsequent loads</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked(get_option('vssv_object_cache_enabled', false)); ?> data-option="vssv_object_cache_enabled">
                    Enable Object Caching
                </label>
                <p class="vs-setting-desc">Cache database queries and computed values</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked(get_option('vssv_browser_cache_enabled', true)); ?> data-option="vssv_browser_cache_enabled">
                    Enable Browser Caching Headers
                </label>
                <p class="vs-setting-desc">Set appropriate cache headers for static assets</p>
            </div>
        </div>
    </div>

    <!-- Cache Actions -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="zap" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Cache Actions
        </h3>
        <div class="vs-actions-grid">
            <button class="vssv-action-btn" onclick="vssv_quickAction('clear-page-cache')">
                <i data-lucide="file-x"></i>
                <span>Clear Page Cache</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('clear-object-cache')">
                <i data-lucide="database"></i>
                <span>Clear Object Cache</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('preload-cache')">
                <i data-lucide="refresh-cw"></i>
                <span>Preload Cache</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('purge-cdn')">
                <i data-lucide="cloud-off"></i>
                <span>Purge CDN</span>
            </button>
        </div>
    </div>
</div>
