<?php
/**
 * Dashboard Page
 *
 * Performance overview with key metrics and quick actions
 *
 * @package VS_Site_Vector
 * @since 2.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get performance data
$score = get_option('vssv_performance_score', 0);
$factors = get_option('vssv_performance_factors', array());
$cache_stats = get_option('vssv_cache_stats', array(
    'hits' => 0,
    'misses' => 0,
    'writes' => 0,
    'deletes' => 0,
));

// Get Web Vitals summary
$vssv = VS_Site_Vector::get_instance();
$vitals_stats = $vssv->get_web_vitals_stats(7);
?>
<div class="vs-page">
    <div class="vs-page-header">
        <h1>Performance Dashboard</h1>
        <div class="vs-page-actions">
            <button
                class="vs-btn vs-btn-primary"
                hx-post="<?php echo admin_url('admin-ajax.php?action=vssv_run_optimization&_wpnonce=' . wp_create_nonce('vssv_ajax_nonce')); ?>"
                hx-swap="none"
                onclick="vssv_handleOptimization(this)"
            >
                <i data-lucide="zap" style="width:16px;height:16px;margin-right:6px;"></i>
                Run Optimization
            </button>
            <button
                class="vs-btn"
                hx-get="<?php echo admin_url('admin-ajax.php?action=vssv_htmx_load_page&page=dashboard&_wpnonce=' . wp_create_nonce('vssv_htmx_load_page')); ?>"
                hx-target="#vssv-content"
                hx-swap="innerHTML"
            >
                <i data-lucide="refresh-cw" style="width:16px;height:16px;margin-right:6px;"></i>
                Refresh
            </button>
        </div>
    </div>

    <!-- Performance Score -->
    <div class="vs-stats-grid">
        <div class="vs-stat-card vssv-stat-score">
            <div class="vs-stat-card-value"><?php echo esc_html($score); ?></div>
            <div class="vs-stat-card-label">Performance Score</div>
            <div class="vssv-stat-sub">/100</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo number_format($cache_stats['hits']); ?></div>
            <div class="vs-stat-card-label">Cache Hits</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo esc_html(get_transient('vssv_avg_load_time') ?: '0'); ?>s</div>
            <div class="vs-stat-card-label">Avg Load Time</div>
        </div>
        <div class="vs-stat-card">
            <div class="vs-stat-card-value"><?php echo esc_html(round(get_transient('vssv_cache_hit_rate') ?: 0)); ?>%</div>
            <div class="vs-stat-card-label">Cache Hit Rate</div>
        </div>
    </div>

    <!-- Web Vitals Summary -->
    <?php if (!empty($vitals_stats['total_samples'])): ?>
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="activity" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Web Vitals (Last 7 Days)
        </h3>
        <div class="vssv-vitals-grid">
            <div class="vssv-vital-item">
                <span class="vssv-vital-label">LCP</span>
                <span class="vssv-vital-value <?php echo ($vitals_stats['avg_lcp'] ?? 0) <= 2500 ? 'good' : (($vitals_stats['avg_lcp'] ?? 0) <= 4000 ? 'needs-improvement' : 'poor'); ?>">
                    <?php echo number_format(($vitals_stats['avg_lcp'] ?? 0) / 1000, 2); ?>s
                </span>
            </div>
            <div class="vssv-vital-item">
                <span class="vssv-vital-label">FID</span>
                <span class="vssv-vital-value <?php echo ($vitals_stats['avg_fid'] ?? 0) <= 100 ? 'good' : (($vitals_stats['avg_fid'] ?? 0) <= 300 ? 'needs-improvement' : 'poor'); ?>">
                    <?php echo number_format($vitals_stats['avg_fid'] ?? 0); ?>ms
                </span>
            </div>
            <div class="vssv-vital-item">
                <span class="vssv-vital-label">CLS</span>
                <span class="vssv-vital-value <?php echo ($vitals_stats['avg_cls'] ?? 0) <= 0.1 ? 'good' : (($vitals_stats['avg_cls'] ?? 0) <= 0.25 ? 'needs-improvement' : 'poor'); ?>">
                    <?php echo number_format($vitals_stats['avg_cls'] ?? 0, 3); ?>
                </span>
            </div>
            <div class="vssv-vital-item">
                <span class="vssv-vital-label">Samples</span>
                <span class="vssv-vital-value"><?php echo number_format($vitals_stats['total_samples']); ?></span>
            </div>
        </div>
        <p style="margin-top:12px;font-size:13px;color:var(--vssv-text-secondary);">
            <a href="<?php echo admin_url('admin.php?page=vs-site-vector&view=web-vitals'); ?>"
               hx-get="<?php echo admin_url('admin-ajax.php?action=vssv_htmx_load_page&page=web-vitals&_wpnonce=' . wp_create_nonce('vssv_htmx_load_page')); ?>"
               hx-target="#vssv-content"
               hx-swap="innerHTML"
               hx-push-url="?page=vs-site-vector&view=web-vitals"
               style="color:var(--vssv-accent);">
                View detailed Web Vitals report →
            </a>
        </p>
    </div>
    <?php endif; ?>

    <!-- Performance Breakdown -->
    <?php if (!empty($factors)): ?>
    <div class="vs-card vs-mt-xl">
        <h3>Performance Breakdown</h3>
        <div class="vssv-factors">
            <?php foreach ($factors as $factor => $value): ?>
            <div class="vssv-factor-row">
                <span class="vssv-factor-name"><?php echo esc_html(ucfirst(str_replace('_', ' ', $factor))); ?></span>
                <div class="vssv-factor-bar">
                    <div class="vssv-factor-fill" style="width: <?php echo esc_attr(min(100, ($value / 40) * 100)); ?>%"></div>
                </div>
                <span class="vssv-factor-value"><?php echo esc_html(round($value)); ?></span>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Quick Actions -->
    <div class="vs-card vs-mt-xl">
        <h3>Quick Actions</h3>
        <div class="vs-actions-grid">
            <button class="vssv-action-btn" onclick="vssv_quickAction('optimize-images')">
                <i data-lucide="image"></i>
                <span>Optimize Images</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('minify-assets')">
                <i data-lucide="file-code"></i>
                <span>Minify Assets</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('preload-cache')">
                <i data-lucide="refresh-cw"></i>
                <span>Preload Cache</span>
            </button>
            <button class="vssv-action-btn" onclick="vssv_quickAction('optimize-database')">
                <i data-lucide="database"></i>
                <span>Optimize Database</span>
            </button>
        </div>
    </div>
</div>
