<?php
/**
 * Optimization Settings Page
 *
 * Configure active optimizations
 *
 * @package VS_Site_Vector
 * @since 2.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$modules = array(
    'minify_html' => array(
        'label' => 'HTML Minification',
        'desc' => 'Remove whitespace and comments from HTML output',
        'icon' => 'code'
    ),
    'minify_css' => array(
        'label' => 'CSS Minification',
        'desc' => 'Compress CSS files and inline styles',
        'icon' => 'palette'
    ),
    'minify_js' => array(
        'label' => 'JavaScript Minification',
        'desc' => 'Compress JavaScript files',
        'icon' => 'file-code'
    ),
    'lazy_load' => array(
        'label' => 'Lazy Loading',
        'desc' => 'Defer loading of images and iframes until visible',
        'icon' => 'image'
    ),
    'defer_js' => array(
        'label' => 'Defer JavaScript',
        'desc' => 'Load non-critical JS after page render',
        'icon' => 'clock'
    ),
    'critical_css' => array(
        'label' => 'Critical CSS',
        'desc' => 'Inline above-the-fold styles for faster rendering',
        'icon' => 'layers'
    ),
    'preload_links' => array(
        'label' => 'Preload Key Resources',
        'desc' => 'Add preload hints for fonts and critical assets',
        'icon' => 'link'
    ),
    'dns_prefetch' => array(
        'label' => 'DNS Prefetch',
        'desc' => 'Resolve external domains early',
        'icon' => 'globe'
    ),
);
?>
<div class="vs-page">
    <div class="vs-page-header">
        <h1>Optimization Settings</h1>
        <div class="vs-page-actions">
            <button
                class="vs-btn vs-btn-primary"
                onclick="vssv_saveOptimizationSettings()"
            >
                <i data-lucide="save" style="width:16px;height:16px;margin-right:6px;"></i>
                Save Changes
            </button>
        </div>
    </div>

    <!-- Optimization Modules -->
    <div class="vs-card">
        <h3>
            <i data-lucide="sliders" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Active Optimizations
        </h3>
        <div class="vs-settings-form">
            <?php foreach ($modules as $key => $module): ?>
            <?php $enabled = get_option('vssv_' . $key . '_enabled', false); ?>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked($enabled); ?> data-option="vssv_<?php echo esc_attr($key); ?>_enabled">
                    <i data-lucide="<?php echo esc_attr($module['icon']); ?>" style="width:16px;height:16px;margin-right:8px;opacity:0.7;"></i>
                    <?php echo esc_html($module['label']); ?>
                </label>
                <p class="vs-setting-desc"><?php echo esc_html($module['desc']); ?></p>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Image Optimization -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="image" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Image Optimization
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked(get_option('vssv_webp_enabled', false)); ?> data-option="vssv_webp_enabled">
                    Convert to WebP
                </label>
                <p class="vs-setting-desc">Automatically convert images to WebP format (30% smaller)</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked(get_option('vssv_responsive_images', true)); ?> data-option="vssv_responsive_images">
                    Responsive Images
                </label>
                <p class="vs-setting-desc">Generate srcset for responsive image loading</p>
            </div>
        </div>
    </div>

    <!-- Exclusions -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="shield-off" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Exclusions
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row">
                <label class="vs-setting-label" style="display:block;">
                    Excluded URLs (one per line)
                </label>
                <textarea
                    style="width:100%;height:100px;margin-top:8px;font-family:monospace;font-size:13px;"
                    data-option="vssv_excluded_urls"
                    placeholder="/wp-admin/*&#10;/checkout/*&#10;/my-account/*"
                ><?php echo esc_textarea(get_option('vssv_excluded_urls', '')); ?></textarea>
                <p class="vs-setting-desc">URLs matching these patterns will not be optimized</p>
            </div>
        </div>
    </div>
</div>
