<?php
/**
 * Settings Page
 *
 * General plugin settings and configuration
 *
 * @package VS_Site_Vector
 * @since 2.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$safe_mode = get_option('vssv_safe_mode', false);
$emergency_disabled = get_option('vssv_emergency_disabled', false);
$tracking_enabled = get_option('vssv_tracking_enabled', true);
?>
<div class="vs-page">
    <div class="vs-page-header">
        <h1>Settings</h1>
        <div class="vs-page-actions">
            <button
                class="vs-btn vs-btn-primary"
                onclick="vssv_saveAllSettings()"
            >
                <i data-lucide="save" style="width:16px;height:16px;margin-right:6px;"></i>
                Save Changes
            </button>
        </div>
    </div>

    <!-- General Settings -->
    <div class="vs-card">
        <h3>
            <i data-lucide="settings" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            General Settings
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked($tracking_enabled); ?> data-option="vssv_tracking_enabled">
                    Enable Performance Tracking
                </label>
                <p class="vs-setting-desc">Collect Web Vitals from real users (anonymous, no cookies)</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked($safe_mode); ?> data-option="vssv_safe_mode">
                    Safe Mode
                </label>
                <p class="vs-setting-desc">Run only essential features, disable aggressive optimizations</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked($emergency_disabled); ?> data-option="vssv_emergency_disabled">
                    Emergency Disable
                </label>
                <p class="vs-setting-desc">Bypass all optimizations (use if site breaks)</p>
            </div>
        </div>
    </div>

    <!-- Tracking Settings -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="activity" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Web Vitals Tracking
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row">
                <label class="vs-setting-label">
                    <input type="checkbox" <?php checked(get_option('vssv_track_admin', false)); ?> data-option="vssv_track_admin">
                    Track Admin Users
                </label>
                <p class="vs-setting-desc">Include logged-in admin users in tracking (disabled by default)</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label" style="display:block;">
                    Sample Rate
                </label>
                <select data-option="vssv_sample_rate" class="vs-select" style="margin-top:8px;">
                    <option value="100" <?php selected(get_option('vssv_sample_rate', 100), 100); ?>>100% (All visitors)</option>
                    <option value="50" <?php selected(get_option('vssv_sample_rate', 100), 50); ?>>50%</option>
                    <option value="25" <?php selected(get_option('vssv_sample_rate', 100), 25); ?>>25%</option>
                    <option value="10" <?php selected(get_option('vssv_sample_rate', 100), 10); ?>>10%</option>
                </select>
                <p class="vs-setting-desc">Percentage of visitors to track (lower = less server load)</p>
            </div>
            <div class="vs-setting-row">
                <label class="vs-setting-label" style="display:block;">
                    Data Retention
                </label>
                <select data-option="vssv_data_retention" class="vs-select" style="margin-top:8px;">
                    <option value="7" <?php selected(get_option('vssv_data_retention', 30), 7); ?>>7 days</option>
                    <option value="30" <?php selected(get_option('vssv_data_retention', 30), 30); ?>>30 days</option>
                    <option value="90" <?php selected(get_option('vssv_data_retention', 30), 90); ?>>90 days</option>
                    <option value="365" <?php selected(get_option('vssv_data_retention', 30), 365); ?>>1 year</option>
                </select>
                <p class="vs-setting-desc">How long to keep Web Vitals data</p>
            </div>
        </div>
    </div>

    <!-- Plugin Info -->
    <div class="vs-card vs-mt-xl">
        <h3>
            <i data-lucide="info" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;"></i>
            Plugin Information
        </h3>
        <div class="vssv-info-list">
            <div class="vssv-info-row">
                <span class="vssv-info-label">Version</span>
                <span class="vssv-info-value"><?php echo esc_html(VSSV_VERSION); ?></span>
            </div>
            <div class="vssv-info-row">
                <span class="vssv-info-label">PHP Version</span>
                <span class="vssv-info-value"><?php echo esc_html(phpversion()); ?></span>
            </div>
            <div class="vssv-info-row">
                <span class="vssv-info-label">WordPress Version</span>
                <span class="vssv-info-value"><?php echo esc_html(get_bloginfo('version')); ?></span>
            </div>
            <div class="vssv-info-row">
                <span class="vssv-info-label">Database Table</span>
                <span class="vssv-info-value">
                    <?php
                    global $wpdb;
                    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '{$wpdb->prefix}vssv_web_vitals'") !== null;
                    echo $table_exists ? '<span class="vssv-status-active">Active</span>' : '<span class="vssv-status-inactive">Missing</span>';
                    ?>
                </span>
            </div>
        </div>
    </div>

    <!-- Danger Zone -->
    <div class="vs-card vs-card-danger vs-mt-xl">
        <h3>
            <i data-lucide="alert-triangle" style="width:18px;height:18px;margin-right:8px;vertical-align:middle;color:#ef4444;"></i>
            Danger Zone
        </h3>
        <div class="vs-settings-form">
            <div class="vs-setting-row" style="border:none;">
                <button class="vs-btn" onclick="vssv_clearVitalsData()">
                    <i data-lucide="trash-2" style="width:16px;height:16px;margin-right:6px;"></i>
                    Clear All Web Vitals Data
                </button>
                <p class="vs-setting-desc" style="margin-left:0;margin-top:8px;">Permanently delete all collected Web Vitals metrics</p>
            </div>
            <div class="vs-setting-row" style="border:none;padding-top:0;">
                <button class="vs-btn vs-btn-danger" onclick="vssv_resetSettings()">
                    <i data-lucide="refresh-ccw" style="width:16px;height:16px;margin-right:6px;"></i>
                    Reset All Settings
                </button>
                <p class="vs-setting-desc" style="margin-left:0;margin-top:8px;">Reset all plugin settings to defaults</p>
            </div>
        </div>
    </div>
</div>
