<?php
/**
 * VS Site Vector Dashboard
 * WordPress Admin Style Interface
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get performance data
$score = get_option('vssv_performance_score', 0);
$factors = get_option('vssv_performance_factors', []);

// Score color class
$score_class = '';
if ($score >= 90) {
    $score_class = 'excellent';
} elseif ($score >= 70) {
    $score_class = 'good';
} else {
    $score_class = 'needs-work';
}
?>

<div class="wrap">
    <h1><?php _e('VS Site Vector', 'vs-site-vector'); ?></h1>

    <div class="notice notice-info">
        <p><?php _e('Welcome to VS Site Vector - Your complete WordPress performance suite.', 'vs-site-vector'); ?></p>
    </div>

    <!-- Performance Score Card -->
    <div class="card">
        <h2><?php _e('Performance Score', 'vs-site-vector'); ?></h2>
        <div class="vssv-score-display">
            <div class="vssv-score-circle <?php echo esc_attr($score_class); ?>">
                <span class="vssv-score-number"><?php echo esc_html($score); ?></span>
                <span class="vssv-score-label">%</span>
            </div>
            <div class="vssv-score-details">
                <p><strong><?php _e('Score Breakdown:', 'vs-site-vector'); ?></strong></p>
                <ul>
                    <li><?php _e('Load Time:', 'vs-site-vector'); ?> <?php echo esc_html($factors['load_time'] ?? 0); ?>/40</li>
                    <li><?php _e('Cache Performance:', 'vs-site-vector'); ?> <?php echo esc_html($factors['cache'] ?? 0); ?>/20</li>
                    <li><?php _e('Database:', 'vs-site-vector'); ?> <?php echo esc_html($factors['database'] ?? 0); ?>/15</li>
                    <li><?php _e('Assets:', 'vs-site-vector'); ?> <?php echo esc_html($factors['assets'] ?? 0); ?>/15</li>
                    <li><?php _e('Images:', 'vs-site-vector'); ?> <?php echo esc_html($factors['images'] ?? 0); ?>/10</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="card">
        <h2><?php _e('Quick Actions', 'vs-site-vector'); ?></h2>
        <p class="description"><?php _e('Optimize your site with one click.', 'vs-site-vector'); ?></p>

        <p>
            <button class="button button-primary button-hero" onclick="vssvRunOptimization()">
                <span class="dashicons dashicons-performance"></span>
                <?php _e('Run Full Optimization', 'vs-site-vector'); ?>
            </button>

            <button class="button button-secondary button-hero" onclick="vssvClearCache()">
                <span class="dashicons dashicons-trash"></span>
                <?php _e('Clear All Caches', 'vs-site-vector'); ?>
            </button>
        </p>
    </div>


    <!-- Cache Statistics -->
    <div class="card">
        <h2><?php _e('Cache Statistics', 'vs-site-vector'); ?></h2>

        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('Cache Type', 'vs-site-vector'); ?></th>
                    <th><?php _e('Hit Rate', 'vs-site-vector'); ?></th>
                    <th><?php _e('Size', 'vs-site-vector'); ?></th>
                    <th><?php _e('Items', 'vs-site-vector'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php _e('Page Cache', 'vs-site-vector'); ?></td>
                    <td><?php echo esc_html(get_transient('vssv_cache_hit_rate') ?: 0); ?>%</td>
                    <td><?php echo size_format(get_option('vssv_cache_size_page', 0)); ?></td>
                    <td><?php echo number_format(get_option('vssv_cache_count_page', 0)); ?></td>
                </tr>
                <tr>
                    <td><?php _e('Object Cache', 'vs-site-vector'); ?></td>
                    <td><?php echo esc_html(get_transient('vssv_object_cache_hit_rate') ?: 0); ?>%</td>
                    <td><?php echo size_format(get_option('vssv_cache_size_object', 0)); ?></td>
                    <td><?php echo number_format(get_option('vssv_cache_count_object', 0)); ?></td>
                </tr>
                <tr>
                    <td><?php _e('Asset Cache', 'vs-site-vector'); ?></td>
                    <td><?php echo esc_html(get_transient('vssv_asset_cache_hit_rate') ?: 0); ?>%</td>
                    <td><?php echo size_format(get_option('vssv_cache_size_asset', 0)); ?></td>
                    <td><?php echo number_format(get_option('vssv_cache_count_asset', 0)); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<style>
/* WordPress Admin Style Dashboard */
.vssv-score-display {
    display: flex;
    gap: 40px;
    align-items: center;
    padding: 20px 0;
}

.vssv-score-circle {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%);
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.vssv-score-circle.excellent {
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
    color: white;
}

.vssv-score-circle.good {
    background: linear-gradient(135deg, #facc15 0%, #f59e0b 100%);
    color: white;
}

.vssv-score-circle.needs-work {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: white;
}

.vssv-score-number {
    font-size: 48px;
    font-weight: bold;
    line-height: 1;
}

.vssv-score-label {
    font-size: 24px;
    opacity: 0.9;
}

.vssv-score-details {
    flex: 1;
}

.vssv-progress-bar {
    width: 100%;
    height: 20px;
    background: #f0f0f0;
    border-radius: 10px;
    overflow: hidden;
    margin: 20px 0;
}

.vssv-progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #2563eb 0%, #22d3ee 100%);
    transition: width 0.3s ease;
}

.button-hero {
    font-size: 16px !important;
    line-height: 2 !important;
    height: auto !important;
    padding: 8px 20px !important;
    margin-right: 10px !important;
}

.button .dashicons {
    vertical-align: middle;
    margin-right: 5px;
}

.card {
    margin-top: 20px;
}

.card h2 {
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
}
</style>

<script>
jQuery(document).ready(function($) {
});

// Global functions for optimization and cache clearing
function vssvRunOptimization() {
    if (!confirm('Run full optimization? This may take a moment.')) return;

    jQuery.post(ajaxurl, {
        action: 'vssv_run_optimization',
        nonce: '<?php echo wp_create_nonce('vssv_ajax_nonce'); ?>'
    }, function(response) {
        if (response.success) {
            alert('Optimization completed successfully!');
            location.reload();
        } else {
            alert('Optimization failed.');
        }
    });
}

function vssvClearCache() {
    if (!confirm('Clear all caches?')) return;

    jQuery.post(ajaxurl, {
        action: 'vssv_clear_cache',
        nonce: '<?php echo wp_create_nonce('vssv_ajax_nonce'); ?>'
    }, function(response) {
        if (response.success) {
            alert('All caches cleared successfully!');
            location.reload();
        } else {
            alert('Failed to clear caches.');
        }
    });
}
</script>