<?php
/**
 * VS Site Vector Deployment Page
 * WordPress Admin Style Interface
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get deployment settings
$deployment_enabled = get_option('vssv_deployment_enabled', false);
$deployment_last_run = get_option('vssv_last_deployment', []);
$deployment_status = get_option('vssv_deployment_status', 'idle');
$deployment_history = get_option('vssv_deployment_history', []);
?>

<div class="wrap">
    <h1><?php _e('Deployment Settings', 'vs-site-vector'); ?></h1>

    <div class="notice notice-info">
        <p><?php _e('Configure automated deployment and static site generation settings.', 'vs-site-vector'); ?></p>
    </div>

    <!-- Deployment Status Card -->
    <div class="card">
        <h2><?php _e('Deployment Status', 'vs-site-vector'); ?></h2>

        <div class="vssv-status-display">
            <p>
                <strong><?php _e('Current Status:', 'vs-site-vector'); ?></strong>
                <span class="vssv-status-badge vssv-status-<?php echo esc_attr($deployment_status); ?>">
                    <?php echo esc_html(ucfirst($deployment_status)); ?>
                </span>
            </p>
        </div>

        <?php if (!empty($deployment_last_run)): ?>
            <div class="vssv-last-deployment">
                <p>
                    <strong><?php _e('Last Deployment:', 'vs-site-vector'); ?></strong>
                    <?php echo esc_html($deployment_last_run['date'] ?? 'Never'); ?>
                </p>
                <?php if (!empty($deployment_last_run['files_deployed'])): ?>
                    <p>
                        <strong><?php _e('Files Deployed:', 'vs-site-vector'); ?></strong>
                        <?php echo esc_html($deployment_last_run['files_deployed']); ?>
                    </p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Deployment Settings Card -->
    <div class="card">
        <h2><?php _e('Deployment Configuration', 'vs-site-vector'); ?></h2>

        <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=vssv-deploy')); ?>">
            <?php wp_nonce_field('vssv_deployment_nonce'); ?>

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="vssv_deployment_enabled">
                            <?php _e('Enable Automatic Deployment', 'vs-site-vector'); ?>
                        </label>
                    </th>
                    <td>
                        <input type="checkbox"
                               id="vssv_deployment_enabled"
                               name="vssv_deployment_enabled"
                               value="1"
                               <?php checked($deployment_enabled, 1); ?> />
                        <p class="description">
                            <?php _e('Automatically deploy static files and cache to CDN or remote server.', 'vs-site-vector'); ?>
                        </p>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="vssv_deployment_frequency">
                            <?php _e('Deployment Frequency', 'vs-site-vector'); ?>
                        </label>
                    </th>
                    <td>
                        <select id="vssv_deployment_frequency" name="vssv_deployment_frequency">
                            <option value="manual"><?php _e('Manual Only', 'vs-site-vector'); ?></option>
                            <option value="hourly"><?php _e('Hourly', 'vs-site-vector'); ?></option>
                            <option value="daily"><?php _e('Daily', 'vs-site-vector'); ?></option>
                            <option value="weekly"><?php _e('Weekly', 'vs-site-vector'); ?></option>
                        </select>
                        <p class="description">
                            <?php _e('How often to run automatic deployments.', 'vs-site-vector'); ?>
                        </p>
                    </td>
                </tr>
            </table>

            <?php submit_button(__('Save Deployment Settings', 'vs-site-vector')); ?>
        </form>
    </div>

    <!-- Action Buttons -->
    <div class="card">
        <h2><?php _e('Actions', 'vs-site-vector'); ?></h2>

        <p>
            <button class="button button-primary" id="vssv-deploy-now">
                <?php _e('Deploy Now', 'vs-site-vector'); ?>
            </button>
            <button class="button" id="vssv-clear-deployment">
                <?php _e('Clear Deployment', 'vs-site-vector'); ?>
            </button>
        </p>

        <div id="vssv-deployment-status-message" class="notice" style="display:none;"></div>
    </div>

    <!-- Deployment History -->
    <?php if (!empty($deployment_history)): ?>
        <div class="card">
            <h2><?php _e('Deployment History', 'vs-site-vector'); ?></h2>

            <table class="widefat striped">
                <thead>
                    <tr>
                        <th><?php _e('Date', 'vs-site-vector'); ?></th>
                        <th><?php _e('Status', 'vs-site-vector'); ?></th>
                        <th><?php _e('Files', 'vs-site-vector'); ?></th>
                        <th><?php _e('Duration', 'vs-site-vector'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach (array_reverse($deployment_history) as $entry): ?>
                        <tr>
                            <td><?php echo esc_html($entry['date'] ?? '—'); ?></td>
                            <td>
                                <span class="vssv-status-badge vssv-status-<?php echo esc_attr($entry['status'] ?? 'unknown'); ?>">
                                    <?php echo esc_html(ucfirst($entry['status'] ?? 'Unknown')); ?>
                                </span>
                            </td>
                            <td><?php echo esc_html($entry['files_deployed'] ?? '0'); ?></td>
                            <td><?php echo esc_html($entry['duration'] ?? '—'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<style>
.vssv-status-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 3px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.vssv-status-idle {
    background-color: #f0f0f0;
    color: #666;
}

.vssv-status-deploying {
    background-color: #fff8e5;
    color: #856404;
}

.vssv-status-success {
    background-color: #d4edda;
    color: #155724;
}

.vssv-status-error {
    background-color: #f8d7da;
    color: #721c24;
}

.vssv-last-deployment {
    margin-top: 15px;
    padding-top: 15px;
    border-top: 1px solid #eee;
}

.vssv-last-deployment p {
    margin: 5px 0;
}
</style>
